/*** 1.   ũƮ ***/

CREATE TABLE TB_Vip01 (level INT, logtime DATETIME, fileId VARCHAR(50))

INSERT INTO TB_Vip01
SELECT seq%59+1 AS level
	, CASE WHEN (seq%59+1)%2=0 THEN DATEADD(SS, -seq, '2020-08-09 00:00:00.000') 
	  ELSE DATEADD(SS, -seq, '2020-09-09 00:00:00.000') END AS logtime
	, NEWID() AS fileId
FROM (SELECT ROW_NUMBER() OVER (ORDER BY a.number) AS seq
	 FROM master..spt_values a JOIN master..spt_values b 
	 ON a.type ='P' 
	 AND b.type ='P'
	 AND a.number < 1000 
	 AND b.number < 1000 
) c

CREATE INDEX IDX01_Vip01 ON TB_Vip01(logtime,level)
GO


/*** 2. [AS-IS] SQL    ȹ ***/

SELECT DISTINCT level
FROM TB_Vip01
WHERE logtime BETWEEN '20200901' AND '20200908'
ORDER BY level
GO


/*** 6. [TO-BE]   ***/

--ε  
CREATE INDEX NIDX02_Vip01 ON TB_Vip01(level, logtime)
GO

--SQL 
SELECT a.level
FROM (SELECT number as level
	 FROM master..spt_values WITH(NOLOCK) 
	 WHERE type = 'P' AND number BETWEEN 1 AND 60) a
WHERE EXISTS (SELECT level
			FROM TB_Vip01
			WHERE level = a.level AND logtime BETWEEN '20200901' AND '20200908')
ORDER BY a.level
GO